package jcircus.environment;


import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import jcircus.exceptions.ChanUseUnificationException;
import jcircus.exceptions.DifferentCardinalitiesException;
import jcircus.exceptions.MoreThanOneWriterException;
import jcircus.exceptions.NotYetImplementedException;

/**
 * ChanInfoEnv.java
 *
 * @author Angela Freitas
 */
public class ChanInfoEnv {
    
    private TreeMap chanInfoEnv_;
        
    /**
     * Creates a new instance of ChannelMSEnv 
     */
    public ChanInfoEnv() {
        
        this.chanInfoEnv_ = new TreeMap();
    }
    
    /**
     *
     */
    public void put(String channelName, ProcChanUseEnv procChanUseEnv) {
        this.chanInfoEnv_.put(channelName, procChanUseEnv);
    }

    /**
     *
     */
    public ProcChanUseEnv get(String channelName) {
        return (ProcChanUseEnv) this.chanInfoEnv_.get(channelName); 
    }
    
    /**
     *
     */
    public Iterator iteratorKeys() {
        return this.chanInfoEnv_.keySet().iterator();
    }
    
    /**
     *
     */
    public Iterator iteratorValues() {
        return this.chanInfoEnv_.values().iterator();
    }

    /**
     *
     */
    public boolean containsKey(String channelName) {
        return this.chanInfoEnv_.containsKey(channelName);
    }
    
    /**
     *
     */
    public ChanInfoEnv merge(ChanInfoEnv other, boolean isParallel) 
            throws MoreThanOneWriterException, ChanUseUnificationException,
                DifferentCardinalitiesException {
        
        ChanInfoEnv result = new ChanInfoEnv();
        
        Iterator itThis = this.iteratorKeys();
        
        String channelName;
        ProcChanUseEnv thisSyncEnv, otherSyncEnv, resultSyncEnv;
        
        // Puts in result all that is in this 
        while(itThis.hasNext()) {
            channelName = (String) itThis.next();
            thisSyncEnv = (ProcChanUseEnv) this.get(channelName);
            
            if (other.containsKey(channelName)) {
                otherSyncEnv = (ProcChanUseEnv) other.get(channelName);
                resultSyncEnv = thisSyncEnv.merge(otherSyncEnv, isParallel);
            } else {
                // ATTENTION: Do I need to clone?
                resultSyncEnv = thisSyncEnv;
            }
            
            result.put(channelName, resultSyncEnv);
        }
        
        Iterator itOther = other.iteratorKeys();
        
        // Puts in result all that is in other but not in this
        while(itOther.hasNext()) {
            channelName = (String) itOther.next();
            otherSyncEnv = other.get(channelName);
            
            if (!(this.containsKey(channelName))) {

                // ATTENTION: Do I need to clone?
                result.put(channelName, otherSyncEnv);
            } else {
                // It has already been inserted in the previous loop
            }
            
        }

        return result;
    }
    
    public ChanInfoEnv substitute(List newChannels, List oldChannels)  {
        throw new NotYetImplementedException();
    }
    
    /**
     * Returns true if any of the channels has cardinality > 1.
     */
    public boolean isMultiSync() {
        
        Iterator it = this.iteratorValues();
        
        while(it.hasNext()) {
            ProcChanUseEnv syncEnv = (ProcChanUseEnv) it.next();
            if (syncEnv.isMultiSync())
                return true;
        }
        
        return false;
    }
    
    public int size() {
        return this.chanInfoEnv_.size();
    }
    
    public int noMultiSync() {

        int no = 0;
        Iterator it = this.iteratorValues();
        
        while(it.hasNext()) {
            ProcChanUseEnv syncEnv = (ProcChanUseEnv) it.next();
            if (syncEnv.isMultiSync())
                no++;;
        }
        
        return no;
    }

    /**
     * The precondition for this operation is that this environment is 
     * for a basic process, that is, only one element in each ProcChanUseEnv and
     * the domains of all ProcChanUseEnv are the same.
     * 
     * @return the old id.
     */
    public ChanInfoEnv replaceId(Integer newId) {
    
        ChanInfoEnv r = new ChanInfoEnv();
        
        Integer oldId = null, idBasicProc = null;
        ProcChanUseEnv chanMSEnv, newChanMSEnv;
        
        Iterator it = this.iteratorKeys();
        
        while (it.hasNext()) {
            String chanName = (String) it.next();
            chanMSEnv = get(chanName);
            newChanMSEnv = chanMSEnv.replaceId(newId, oldId); 
            
            // Check if the id has been maintained equal
            if (idBasicProc != null) {
                if (!oldId.equals(idBasicProc)) {
                    throw new RuntimeException("Method replaceIds has been " +
                            "called for a non-basic process.");
                }
            }
            idBasicProc = oldId;
            
            r.put(chanName, newChanMSEnv);
        }
        
        return r;
    }
    
    /**
     *
     */
    public String print(int nTabs) {
        
        String tabs = "";
        while(nTabs > 0) {
            tabs = tabs + "\t";
            nTabs--;
        }
            
        StringBuilder s = new StringBuilder();
        s.append(tabs + "MultiSync\n");
        Iterator it = this.iteratorKeys();
        
        while(it.hasNext()) {
            String pName = (String) it.next();
            ProcChanUseEnv syncEnv = this.get(pName);
            s.append(tabs + pName + " -> \n");
            s.append(syncEnv.print(nTabs + 1));
        }
        return s.toString();
    }
    
}
